DROP PROCEDURE [hips].[ContactByPatientList]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 October 2012
-- Description:   Gets all the Contact records for a patient
-- =============================================
CREATE PROCEDURE [hips].[ContactByPatientList] 
(
	@PatientMasterId INT
)
AS
BEGIN
	SELECT  c.ContactId,
			c.Detail,
			c.ContactMethodId,
			cm.Description AS ContactMethodDescription,
			cm.TelecommunicationType,
			cm.CdaType,
			c.DateCreated,
			c.UserCreated,
			c.DateModified,
			c.UserModified
			
	FROM  hips.PatientMasterContact as pmc
	LEFT OUTER JOIN hips.Contact c ON c.ContactId = pmc.ContactId
	LEFT OUTER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
	WHERE pmc.PatientMasterId = @PatientMasterId
END
GO

